/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.config;

import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClassData {
    private String className = null;
    private Map configData = null;
    private static final String TAG_CLASS = "class";
    private static final String TAG_MAP = "map";
    private static final String TAG_KEY = "key";
    private static final String ATTRIB_NAME = "name";

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setConfigData(Map configData) {
        if (this.configData != null) {
            throw new RuntimeException("Configuration data is already set, duplicate tags?");
        }
        this.configData = configData;
    }

    public Map getConfigData() {
        return this.configData;
    }

    public static ClassData parseClassDef(Node node) throws MalformedXMLException {
        ClassData classData = new ClassData();
        NodeList nodes = node.getChildNodes();
        int aii = 0;
        while (aii < nodes.getLength()) {
            Node subnode = nodes.item(aii);
            if (subnode.getNodeType() == 1) {
                String tag = subnode.getNodeName().toLowerCase();
                if (tag.equals(TAG_CLASS)) {
                    classData.setClassName(CommonXMLParser.gatherTextContents(subnode));
                } else {
                    classData.setConfigData(ClassData.parseInputMap(subnode));
                }
            }
            ++aii;
        }
        return classData;
    }

    public static Map parseInputMap(Node node) throws MalformedXMLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                Node name = child.getAttributes().getNamedItem(ATTRIB_NAME);
                if (TAG_MAP.equals(child.getNodeName().toLowerCase())) {
                    if (name == null || name.getNodeType() != 2) {
                        throw new MalformedXMLException("Unable to locate name attribute on <map> entry");
                    }
                    if (map.containsKey(name.getNodeValue())) {
                        throw new MalformedXMLException("Name key '" + name.getNodeValue() + "' already exists in map at this level.");
                    }
                    map.put(name.getNodeValue(), ClassData.parseInputMap(child));
                } else if (TAG_KEY.equals(child.getNodeName().toLowerCase())) {
                    if (name == null || name.getNodeType() != 2) {
                        throw new MalformedXMLException("Unable to locate name attribute on <key> entry");
                    }
                    if (map.containsKey(name.getNodeValue())) {
                        throw new MalformedXMLException("Name key '" + name.getNodeValue() + "' already exists in map at this level.");
                    }
                    map.put(name.getNodeValue(), CommonXMLParser.gatherTextContents(child));
                } else {
                    throw new MalformedXMLException("Unknown tag ??? " + child.getNodeName().toLowerCase());
                }
            }
            ++i;
        }
        return map;
    }

    public String toString() {
        return "ClassData name[" + this.className + "],config[" + this.configData + "]";
    }
}

